uniform sampler2D 	posTex,
					causticsTex,
					colorTex;

varying vec2 		texcoord;
varying vec2		VPOS;
uniform float		waterY;
uniform mat4		eyeToWorldTM;
uniform vec3		SUN;
uniform vec2		ofs;

uniform vec4	LTM0,
				LTM1,
				LTM3;
				
uniform vec4	LTM0b,
				LTM1b,
				LTM3b;
			
uniform vec4	LTM0c,
				LTM1c,
				LTM3c;
				
void main()
{
	vec4 color = texture2D(colorTex,texcoord.st);
	vec4 pos = texture2D(posTex,texcoord.st);
	pos.xy=VPOS*-pos.z;
	pos.w=1.0;
	vec4 Wpos=eyeToWorldTM*pos;

	if(Wpos.y>waterY)
		discard;

	vec4	XYproj;	
	vec3 	projcoords;
	
	// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
	XYproj.x = dot(pos,LTM0);
	XYproj.y = dot(pos,LTM1);
	XYproj.w = dot(pos,LTM3);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords0=projcoords.xy;//*220.0 - ofs;
	
	XYproj.x = dot(pos,LTM0b);
	XYproj.y = dot(pos,LTM1b);
	XYproj.w = dot(pos,LTM3b);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords1=projcoords.xy;//*120.0 + ofs;
	
	XYproj.x = dot(pos,LTM0c);
	XYproj.y = dot(pos,LTM1c);
	XYproj.w = dot(pos,LTM3c);
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords2=projcoords.xy;//*120.0 + ofs;
	
	//float Y=max(Wpos.y,0.0)*0.001;
	float c0,c1,c2;
	c0=texture2D(causticsTex,coords0.xy).r;
	c1=texture2D(causticsTex,coords1.xy).r;
	c2=texture2D(causticsTex,coords2.xy).r;
	
	vec3 CR=SUN*( (c0*c1*c2*3.0) + (c0+c1+c2) )*color.xyz;
	gl_FragColor.rgb=max(mix(vec3(0.0,0.0,0.0),CR,clamp( (waterY-Wpos.y)*0.1 ,0.0,1.0)),0.0);
	gl_FragColor.a=1.0;//max(texture2D(causticsTex,coords0.xy).r/*+texture2D(causticsTex,coords1.xy).r*/,1.0);
//	}
}
